<?php if (!defined('__TYPECHO_ROOT_DIR__')) exit; ?>
<!DOCTYPE HTML>
<html>
<head>
    <meta charset="<?php $this->options->charset(); ?>">
    <meta name="renderer" content="webkit">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <title><?php $this->archiveTitle([
            'category' => _t('分类 %s 下的文章'),
            'search'   => _t('包含关键字 %s 的文章'),
            'tag'      => _t('标签 %s 下的文章'),
            'author'   => _t('%s 发布的文章')
        ], '', ' - '); ?><?php $this->options->title(); ?></title>

    <!-- 使用url函数转换相关路径 -->
    <link href="https://cdn.bootcdn.net/ajax/libs/twitter-bootstrap/5.3.1/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="<?php $this->options->themeUrl('style.css'); ?>">

    <!-- 通过自有函数输出HTML头部信息 -->
    <?php $this->header(); ?>
</head>
<body>

<header>
    <div class="container">
        <div class="row">
            <div class="col-3">
                <?php if ($this->options->logoUrl): ?>
                    <a id="logo" href="<?php $this->options->siteUrl(); ?>">
                        <img class="logo logo-light-mode" src="<?php $this->options->logoUrl() ?>" alt="<?php $this->options->title() ?>"/>
                        <img class="logo logo-dark-mode" src="<?php $this->options->logoUrlDark() ?>" alt="<?php $this->options->title() ?>"/>
                    </a>
                <?php else: ?>
                    <a id="logo" href="<?php $this->options->siteUrl(); ?>"><?php $this->options->title() ?></a>
                <?php endif; ?>
            </div>
            <div class="col-9">
                <nav class="nav-menu" role="navigation">
                    <?php \Widget\Contents\Page\Rows::alloc()->to($pages); ?>
                    <?php while ($pages->next()): ?>
                        <a class="nav-current"<?php if ($this->is('page', $pages->slug)): ?> <?php endif; ?>
                            href="<?php $pages->permalink(); ?>"
                            title="<?php $pages->title(); ?>"><?php $pages->title(); ?></a>
                    <?php endwhile; ?>
                    <a href="" class="nav-current search-button">
                        <svg class="search-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" width="16" height="16"><path d="M10.68 11.74a6 6 0 0 1-7.922-8.982 6 6 0 0 1 8.982 7.922l3.04 3.04a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215ZM11.5 7a4.499 4.499 0 1 0-8.997 0A4.499 4.499 0 0 0 11.5 7Z"></path></svg>
                    </a>
                </nav>
            </div>
            <div class="site-search col-12">
                <form id="search" method="post" action="<?php $this->options->siteUrl(); ?>" role="search">
                    <div class="search-wrapper">
                        <svg class="search-icon2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" width="16" height="16">
                            <path d="M10.68 11.74a6 6 0 0 1-7.922-8.982 6 6 0 0 1 8.982 7.922l3.04 3.04a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215ZM11.5 7a4.499 4.499 0 1 0-8.997 0A4.499 4.499 0 0 0 11.5 7Z"></path>
                        </svg>
                        <input type="text" id="s" name="s" class="search-input" placeholder="<?php _e('输入关键字搜索'); ?>"/>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const header = document.querySelector("header");
            const searchButton = document.querySelector(".search-button");
            const siteSearch = document.querySelector(".site-search");

            function toggleSearch() {
                const isExpanded = header.classList.contains("expanded");
                if (isExpanded) {
                    header.classList.remove("expanded");
                    siteSearch.classList.remove("show");
                } else {
                    header.classList.add("expanded");
                    siteSearch.classList.add("show");
                }
            }

            function closeSearch(event) {
                if (!header.contains(event.target)) {
                    header.classList.remove("expanded");
                    siteSearch.classList.remove("show");
                }
            }

            searchButton.addEventListener("click", function (event) {
                event.preventDefault(); // 防止页面跳转
                toggleSearch();
            });

            document.addEventListener("click", closeSearch);

            document.getElementById("infoButton").addEventListener("click", function () {
                document.getElementById("infoPanel").classList.toggle("active");
                document.getElementById("overlay").classList.toggle("active");
            });
            document.getElementById("overlay").addEventListener("click", function () {
                document.getElementById("infoPanel").classList.remove("active");
                document.getElementById("overlay").classList.remove("active");
            });

        });
    </script>
</header>
<div id="body" class="main">
    <div id="overlay" class="overlay"></div>
    <div class="container">
        <div class="row">

    
    
