<?php if (!defined('__TYPECHO_ROOT_DIR__')) exit; ?>
<?php if ($this->allow('comment')): ?>
<div class="d-flex justify-content-center align-items-center">
    <div class="comments-button" id="infoButton">
        <svg width="18" height="18" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M33 38H22V30H36V22H44V38H39L36 41L33 38Z" stroke="#444445" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"/><path d="M4 6H36V30H17L13 34L9 30H4V6Z" fill="none" stroke="#444445" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"/><path d="M12 22H18" stroke="#444445" stroke-width="4" stroke-linecap="round"/><path d="M12 14H24" stroke="#444445" stroke-width="4" stroke-linecap="round"/></svg>
        <span class="commentsNum"><?php $this->commentsNum(_t(''), _t('&nbsp; %d')); ?></span>
    </div>
</div>
<div id="infoPanel" class="info-panel">
    <div class="info-content">
        <?php $this->comments()->to($comments); ?>
        <div id="<?php $this->respondId(); ?>">
            <div class="comment-create-card">
                <div class="cancel-comment-reply">
                    <?php $comments->cancelReply(); ?>
                </div>
                <form method="post" action="<?php $this->commentUrl() ?>" id="comment-form" role="form">
                    <div class="comment-create-header">
                        <h4 class="mb-3 fw-bold">新留言</h4>
                        <button type="submit" class="sumbit-btn logo-light-mode">
                            <svg width="20" height="20" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M42 6L4 20.1383L24 24.0083L29.0052 44L42 6Z" stroke="#222529" stroke-width="4" stroke-linejoin="round"/><path d="M24.0083 24.0084L29.6651 18.3516" stroke="#222529" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"/></svg>
                        </button>
                        <button type="submit" class="sumbit-btn logo-dark-mode">
                            <svg width="20" height="20" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M43 5L29.7 43L22.1 25.9L5 18.3L43 5Z" stroke="#ECECEC" stroke-width="4" stroke-linejoin="round"/><path d="M43.0001 5L22.1001 25.9" stroke="#ECECEC" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"/></svg>
                        </button>
                    </div>
                    <div class="row">
                        <?php if ($this->user->hasLogin()): ?>
                            <div class="col-12">
                                <?php _e('登录身份: '); ?><?php $this->user->screenName(); ?>
                            </div>
                        <?php else: ?>
                            <div class="col-6">
                                <input type="text" name="author" id="author" value="<?php $this->remember('author'); ?>" placeholder="名称" required />
                            </div>
                            <div class="col-6">
                                <input type="email" name="mail" id="mail" placeholder="电子邮件地址" value="<?php $this->remember('mail'); ?>" <?php if ($this->options->commentsRequireMail): ?> required<?php endif; ?> />
                            </div>
                        <?php endif; ?>
                        <div class="col-12 mt-3">
                            <textarea rows="6" cols="50" name="text" id="textarea" class="textarea" placeholder="在此输入内容，点击右上角图标提交。" required><?php $this->remember('text'); ?></textarea>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <?php while($comments->next()): ?>
            <div class="comment-card m-3">
                <div class="">
                    <?php //$comments->gravatar('100', ''); ?>
                    <div class="fw-bold fs-6"><?php $comments->author(); ?></div>
                    <div class="text-secondary"><?php $comments->date('Y年m月d日 H:i'); ?></div>
                </div>
                <p><?php $comments->content(); ?></p>
                </div>
        <?php endwhile; ?>
    </div>
</div>

<?php else: ?>
<?php endif; ?>