<?php if (!defined('__TYPECHO_ROOT_DIR__')) exit; ?>
<?php $this->need('header.php'); ?>

<div class="container">
    <h3 class="archive-title"><?php $this->archiveTitle([
            'category' => _t('分类 %s 下的文章'),
            'search'   => _t('包含关键字 %s 的文章'),
            'tag'      => _t('标签 %s 下的文章'),
            'author'   => _t('%s 发布的文章')
        ], '', ''); ?></h3>
    <?php if ($this->have()): ?>
        <?php while ($this->next()): ?>
            <div class="search-card" data-url="<?php $this->permalink() ?>">
                <div class="cover_image">
                    <img src="<?php $this->fields->cover_image() ?>">
                </div>
                <div class="content p-5">
                    <h5 class="card-title fw-bold"><?php $this->title() ?></h5>
                    <p class="card-text mt-3"><?php $this->date('F j, Y'); ?></p>
                </div>
            </div>
        <?php endwhile; ?>
    <?php else: ?>
        <p class="my-5 text-center fs-4 fw-bold text-secondary">未找到内容&nbsp;&nbsp;<a href="/">返回首页</a></p>
    <?php endif; ?>

    <?php $this->pageNav('上一页', '下一页', 10);  ?>
</div><!-- end #main -->

<script>
    document.addEventListener('DOMContentLoaded', () => {
        const postCards = document.querySelectorAll('.search-card');

        postCards.forEach(postCard => {
            postCard.addEventListener('click', () => {
                const url = postCard.getAttribute('data-url');
                if (url) {
                    window.location.href = url;
                }
            });
        });
    });
</script>

<?php $this->need('sidebar.php'); ?>
<?php $this->need('footer.php'); ?>
